//#include <bits/stdc++.h>
#include <vector>
#include <string>
#include <exception>
#include <regex>
#include <iostream>
#include <fstream>
#include <iomanip>
#include <algorithm>

using namespace std;

vector<double> resistors;
vector<int> used;

const double minVal=1.0, maxVal=10000.0;

vector<string> splitArgs(const string &s) {
    vector<string> args;
    int depth = 0;
    string cur;
    for (char c : s) {
        if (c == ',' && depth == 0) {
            if (!cur.empty()) { args.push_back(cur); cur.clear(); }
        } else {
            if (c == '(') depth++;
            if (c == ')') depth--;
            if (depth < 0) throw runtime_error("Mismatched parentheses");
            cur.push_back(c);
        }
    }
    if (!cur.empty())
        args.push_back(cur);
    return args;
}

double parseExpr(const string &expr) {
    string e = expr;
    //e.erase(remove_if(e.begin(), e.end(), ::isspace), e.end());
    if (regex_match(e, regex("r[0-9]+"))) {
        int idx = stoi(e.substr(1));
        if (idx < 0 || idx >= (int)resistors.size())
            throw runtime_error("Index out of range");
        used[idx]++;
        return resistors[idx];
    }
    if (e.rfind("S(",0)==0 && e.back()==')') {
        string inside = e.substr(2, e.size()-3);
        auto parts = splitArgs(inside);
        double sum=0;
        for (auto &p: parts)
            sum += parseExpr(p);
        return sum;
    }
    if (e.rfind("P(",0)==0 && e.back()==')') {
        string inside = e.substr(2, e.size()-3);
        auto parts = splitArgs(inside);
        double denom=0;
        for (auto &p: parts) {
            double v = parseExpr(p);
            denom += 1.0/v;
        }
        return 1.0/denom;
    }
    throw runtime_error("Invalid expression");
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    try {
        int n; cin >> n;
        if (n<=0 || n>30)
            throw runtime_error("Invalid n");
        resistors.resize(n);
        for (int i=0;i<n;i++)
        {
            cin >> resistors[i];
            if (resistors[i]<minVal || resistors[i]>maxVal)
                throw runtime_error("Invalid resistor value");
        }
        string expr;
        //fin.ignore();
        cin >> expr;
        
        if(!expr.empty())
        {
            if((expr.back() == '\r') || (expr.back()=='\n')){
                expr.pop_back();
            }
        }
        
        if ((int)expr.size()>150)
            throw runtime_error("Expression too long");
        
        used.assign(n,0);
        double result = parseExpr(expr);
        
        bool allUsed = all_of(used.begin(), used.end(), [](int u){return u>0;});
        bool anyUnused = any_of(used.begin(), used.end(), [](int u){return u==0;});
        bool anyReused = any_of(used.begin(), used.end(), [](int u){return u>1;});
        
        int flag;
        if (allUsed && !anyReused) flag=1;
        else if (anyUnused && !anyReused) flag=0;
        else if (allUsed && anyReused) flag=2;
        else flag=3;
        
        cout<<fixed<<setprecision(6)<<result<<"\n"<<flag<<"\n";
    } catch(...){
        cout << -1 << "\n";
    }
    return 0;
}
